'use client';

import { useLanguage } from '@/contexts/language-context';
import { Layers, Linkedin, Twitter, Facebook, Youtube, Instagram, Phone, Mail } from 'lucide-react';
import Link from 'next/link';
import Image from 'next/image';

export function Footer() {
  const { content } = useLanguage();

  return (
    <footer className="bg-primary text-primary-foreground">
      <div className="container mx-auto px-4 py-12">
        <div className="grid grid-cols-1 md:grid-cols-3 gap-8 text-center md:text-left">
          {/* Logo and Disclaimer */}
          <div className="flex flex-col items-center md:items-start">
            <div className="flex items-center gap-2 mb-4">
                <div className="relative h-20 w-48">
                   <Image
                      src="/ubc noor.png"
                      alt="UBC NOOR Consortium Logo"
                      fill
                      className="object-contain"
                    />
                </div>
            </div>
            <p className="text-sm text-primary-foreground/80">
              {content.footer.copyright}
            </p>
            <p className="mt-2 text-xs text-primary-foreground/60">
                {content.footer.disclaimer}
            </p>
          </div>

          {/* Contact Info */}
          <div className="flex flex-col items-center md:items-start">
            <h3 className="font-bold text-lg mb-4 text-white">{content.nav.contact}</h3>
            <div className="space-y-3 text-sm text-primary-foreground/80">
              <a href={`mailto:${content.contact.locations.consortium.email}`} className="flex items-center gap-3 hover:text-accent transition-colors">
                <Mail className="h-5 w-5" />
                <span>{content.contact.locations.consortium.email}</span>
              </a>
              <a href={`tel:${content.contact.locations.ubc.phone}`} className="flex items-center gap-3 hover:text-accent transition-colors">
                <Phone className="h-5 w-5" />
                <span>{content.contact.locations.ubc.phone} (UBC)</span>
              </a>
              <a href={`tel:${content.contact.locations.noor.phone}`} className="flex items-center gap-3 hover:text-accent transition-colors">
                <Phone className="h-5 w-5" />
                <span>{content.contact.locations.noor.phone} (Noor)</span>
              </a>
            </div>
          </div>
          
          {/* Social Links */}
          <div className="flex flex-col items-center md:items-start">
            <h3 className="font-bold text-lg mb-4 text-white">Follow Us</h3>
            <div className="flex items-center gap-4">
                <Link href="#" className="text-primary-foreground/80 hover:text-accent p-2 bg-white/10 rounded-full transition-colors"><Linkedin className="h-5 w-5" /></Link>
                <Link href="#" className="text-primary-foreground/80 hover:text-accent p-2 bg-white/10 rounded-full transition-colors"><Youtube className="h-5 w-5" /></Link>
                <Link href="#" className="text-primary-foreground/80 hover:text-accent p-2 bg-white/10 rounded-full transition-colors"><Instagram className="h-5 w-5" /></Link>
            </div>
          </div>
        </div>
      </div>
    </footer>
  );
}
